import { defineFunction } from "@aws-amplify/backend"
import { env } from "../../env.setup";

export const getAllStatewideServices = defineFunction({
  name: 'get-all-statewide-services',
  entry: './handler.ts',
  environment: {
    BACKEND_REST_API_ALLOWED_HEADERS: env.BACKEND_REST_API_ALLOWED_HEADERS,
    BACKEND_REST_API_ALLOWED_ORIGIN: env.BACKEND_REST_API_ALLOWED_ORIGIN,
    BACKEND_REST_API_ALLOWED_METHODS: env.BACKEND_REST_API_ALLOWED_METHODS,

    BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX: env.BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX,
    BACKEND_STATEWIDE_SERVICES_DYNAMOBD_TABLENAME: env.BACKEND_STATEWIDE_SERVICES_DYNAMODB_TABLENAME,
  },
});

